#include "EndState.h"
#include "StateManager.h"
#include "PlayState.h"
#include "Help.h"
#include "Option.h"

EndState::EndState()
{
}

EndState::~EndState()
{
	delete m_Arrow;
}

EndState::EndState(IDStateGame id)
{
	m_ID = id;
}

void EndState::Init()
{
	m_ID = MENU;

	m_Arrow = new Arrow(10, 10, 10, 14, 2);
}

void EndState::Update()
{
	//Selection
	m_Arrow->Update();

	if (GIsKeyPress(KEY_ENTER))
	{
		StateManager::getInstance()->removeStateGame();
		switch (m_Arrow->m_Position.y)
		{
		case 10:
		{
				   StateManager::getInstance()->addStateGame(new PlayState(IDStateGame::PLAYGAME));
				   break;
		}

		case 12:
		{
				   StateManager::getInstance()->addStateGame(new MenuState(IDStateGame::MENU));
				   break;
		}
		case 14:
			exit(1);
			break;
		default:
			break;
		}
	}
}

void EndState::Draw()
{
	m_Arrow->Draw();
	GPutStringToBuffer("GAME OVER", 15, 6);
	GPutStringToBuffer("Play Again", 15, 10);
	GPutStringToBuffer("Main Menu", 15, 12);
	GPutStringToBuffer("Exit", 15, 14);
}